library(pacman) #allows downloading and loading in a single function
p_load(readr, dplyr, tidyverse, ggplot2)

#Author's Note####
#This was my first major project coding in R so the Code 
#may not be arranged in a way you are used to.
#If anything is unclear or you have any questions please do not hesitate to 
#get in contact through our website http://www.sc3.center/. Some of the 
#graphs are saved as variables, and will not immediately appear when you run the
#code. Thank you for the interest in our work. 

#Brayton Noll

#####
Dat <- FL_Adapt_Meta_Analysis
#then as a backup/orginal copy
Data <- Dat

#seperate by metric####
spear <-Dat[Dat$Metric == "Spear",]
odd <-Dat[Dat$Metric == "Odds",]
chi <-Dat[Dat$Metric == "Chi",]
kend <-Dat[Dat$Metric == "Kendall",] 
pear <-Dat[Dat$Metric == "Pearsons",] 
beta <-Dat[Dat$Metric == "beta",] 
logR <-Dat[Dat$Metric == "LogR",]

#Spearmans Rho convert to Pearsons r ####
spear$RP.both <- {2* sin((pi/6) * spear$RP.both)}
spear$RP.act <- {2* sin((pi/6) * spear$RP.act)}
spear$RP.int <- {2* sin((pi/6) * spear$RP.int)}
spear$R.prob <- {2* sin((pi/6) * spear$R.prob)}
spear$R.dam <- {2* sin((pi/6) * spear$R.dam)}
spear$Age <- {2* sin((pi/6) * spear$Age)}
spear$Exp <- {2* sin((pi/6) * spear$Exp)}
spear$Fem <- {2* sin((pi/6) * spear$Fem)}
spear$Self.eff.act <- {2* sin((pi/6) * spear$Self.eff.act)}
spear$Self.eff.int <- {2* sin((pi/6) * spear$Self.eff.int)}
spear$Self.eff <- {2* sin((pi/6) * spear$Self.eff)}
spear$Social <- {2* sin((pi/6) * spear$Social)}
spear$Gov.act <- {2* sin((pi/6) * spear$Gov.act)}

#Chi Sqaured convert to Pearsons r ####
chi$RP.both <- sqrt((chi$RP.both/chi$N))
chi$RP.act <- sqrt((chi$RP.act/chi$N))
chi$RP.int <- sqrt((chi$RP.int/chi$N))
chi$R.prob <- sqrt((chi$R.prob/chi$N))
chi$R.dam <- sqrt((chi$R.dam/chi$N))
chi$Age <- sqrt((chi$Age/chi$N))
chi$Exp <- sqrt((chi$Exp/chi$N))
chi$Fem <- sqrt((chi$Fem/chi$N))
chi$Self.eff <- sqrt((chi$Self.eff/chi$N))
chi$Self.eff.act <- sqrt((chi$Self.eff.act/chi$N))
chi$Self.eff.int <- sqrt((chi$Self.eff.int/chi$N))
chi$Social <- sqrt((chi$Social/chi$N))
chi$Gov.act <- sqrt((chi$Gov.act/chi$N))
#need to make Fem.Adapt ZG negative 
chi$Fem[chi$Fem < .06 & !is.na(chi$Fem)] <- chi$Fem[chi$Fem < .06 & !is.na(chi$Fem)]*-1

#Odds Ratio converted to Pearsons r ####
odd$RP.both <- {sqrt(odd$RP.both) -1} / {sqrt(odd$RP.both) + 1}
odd$RP.act <- {sqrt(odd$RP.act) -1} / {sqrt(odd$RP.act) + 1}
odd$RP.int <- {sqrt(odd$RP.int) -1} / {sqrt(odd$RP.int) + 1}
odd$R.prob <- {sqrt(odd$R.prob) -1} / {sqrt(odd$R.prob) + 1}
odd$R.dam <- {sqrt(odd$R.dam) -1} / {sqrt(odd$R.dam) + 1}
odd$Age <- {sqrt(odd$Age) -1} / {sqrt(odd$Age) + 1}
odd$Exp <- {sqrt(odd$Exp) -1} / {sqrt(odd$Exp) + 1}
odd$Fem <- {sqrt(odd$Fem) -1} / {sqrt(odd$Fem) + 1}
odd$Self.eff <- {sqrt(odd$Self.eff) -1} / {sqrt(odd$Self.eff) + 1}
odd$Self.eff.act <- {sqrt(odd$Self.eff.act) -1} / {sqrt(odd$Self.eff.act) + 1}
odd$Self.eff.int <- {sqrt(odd$Self.eff.int) -1} / {sqrt(odd$Self.eff.int) + 1}
odd$Social <- {sqrt(odd$Social) -1} / {sqrt(odd$Social) + 1}
odd$Gov.act <- {sqrt(odd$Gov.act) -1} / {sqrt(odd$Gov.act) + 1}






#Kendall's Tau converted to Pearsons r ####
kend$RP.both <- sin(.5* pi * kend$RP.both)
kend$RP.act <- sin(.5* pi * kend$RP.act)
kend$RP.int <- sin(.5* pi * kend$RP.int)
kend$R.prob <- sin(.5* pi * kend$R.prob)
kend$R.dam <- sin(.5* pi * kend$R.dam)
kend$Age <- sin(.5* pi * kend$Age)
kend$Exp <- sin(.5* pi * kend$Exp)
kend$Fem <- sin(.5* pi * kend$Fem)
kend$Self.eff <- sin(.5* pi * kend$Self.eff)
kend$Self.eff.act <- sin(.5* pi * kend$Self.eff.act)
kend$Self.eff.int <- sin(.5* pi * kend$Self.eff.int)
kend$Social <- sin(.5* pi * kend$Social)
kend$Gov.act <- sin(.5* pi * kend$Gov.act)






#beta converted to Pearsons r ####

#first create a column containing 1 for the constant landa (l) because r = beta +.05 * l when beta is >= 0
#otherwise, r just = beta (Yes we could have just multiplied by one but this is good record keeping)
beta$one <- 1

beta$RP.both[beta$RP.both >= "0" & !is.na(beta$RP.both)] <- beta$RP.both[beta$RP.both >= "0" & !is.na(beta$RP.both)] + (.05 * beta$one)
beta$RP.act[beta$RP.act >= "0" & !is.na(beta$RP.act)] <- beta$RP.act[beta$RP.act >= "0" & !is.na(beta$RP.act)] + (.05 * beta$one)
beta$RP.int[beta$RP.int >= "0" & !is.na(beta$RP.int)] <- beta$RP.int[beta$RP.int >= "0" & !is.na(beta$RP.int)] + (.05 * beta$one)
beta$R.prob[beta$R.prob >= "0" & !is.na(beta$R.prob)] <- beta$R.prob[beta$R.prob >= "0" & !is.na(beta$R.prob)] + (.05 * beta$one)
beta$R.dam[beta$R.dam >= "0" & !is.na(beta$R.dam)] <- beta$R.dam[beta$R.dam >= "0" & !is.na(beta$R.dam)] + (.05 * beta$one)
beta$Age[beta$Age >= "0" & !is.na(beta$Age)] <- beta$Age[beta$Age >= "0" & !is.na(beta$Age)] + (.05 * beta$one)
beta$Exp[beta$Exp >= "0" & !is.na(beta$Exp)] <- beta$Exp[beta$Exp >= "0" & !is.na(beta$Exp)] + (.05 * beta$one)
beta$Fem[beta$Fem >= "0" & !is.na(beta$Fem)] <- beta$Fem[beta$Fem >= "0" & !is.na(beta$Fem)] + (.05 * beta$one)
beta$Self.eff[beta$Self.eff >= "0" & !is.na(beta$Self.eff)] <- beta$Self.eff[beta$Self.eff >= "0" & !is.na(beta$Self.eff)] + (.05 * beta$one)
beta$Self.eff.act[beta$Self.eff.act >= "0" & !is.na(beta$Self.eff.act)] <- beta$Self.eff.act[beta$Self.eff.act >= "0" & !is.na(beta$Self.eff.act)] + (.05 * beta$one)
beta$Self.eff.int[beta$Self.eff.int >= "0" & !is.na(beta$Self.eff.int)] <- beta$Self.eff.int[beta$Self.eff.int >= "0" & !is.na(beta$Self.eff.int)] + (.05 * beta$one)
beta$Social[beta$Social >= "0" & !is.na(beta$Social)] <- beta$Social[beta$Social >= "0" & !is.na(beta$Social)] + (.05 * beta$one)
beta$Gov.act[beta$Gov.act >= "0" & !is.na(beta$Gov.act)] <- beta$Gov.act[beta$Gov.act >= "0" & !is.na(beta$Gov.act)] + (.05 * beta$one)

#then remove the extra column so that everything alligns nicely at the end 
beta <- select(beta, -one)

#Logistic Regression Coefficents into Pearsons R#####

##First convert to Odds Ratio (Lalongo, 2016)
logR$RP.both <- exp(logR$RP.both)
logR$RP.act <- exp(logR$RP.act)
logR$RP.int <- exp(logR$RP.int)
logR$R.prob <- exp(logR$R.prob)
logR$R.dam <- exp(logR$R.dam)
logR$Age <- exp(logR$Age)
logR$Exp <- exp(logR$Exp)
logR$Fem <- exp(logR$Fem)
logR$Self.eff <- exp(logR$Self.eff)
logR$Self.eff.act <- exp(logR$Self.eff.act)
logR$Self.eff.int <- exp(logR$Self.eff.int)
logR$Social <- exp(logR$Social)
logR$Gov.act <- exp(logR$Gov.act)

#Then, from Odds Ratio to Pearsons R
logR$RP.both <- {sqrt(logR$RP.both) -1} / {sqrt(logR$RP.both) + 1}
logR$RP.act <- {sqrt(logR$RP.act) -1} / {sqrt(logR$RP.act) + 1}
logR$RP.int <- {sqrt(logR$RP.int) -1} / {sqrt(logR$RP.int) + 1}
logR$R.prob <- {sqrt(logR$R.prob) -1} / {sqrt(logR$R.prob) + 1}
logR$R.dam <- {sqrt(logR$R.dam) -1} / {sqrt(logR$R.dam) + 1}
logR$Age <- {sqrt(logR$Age) -1} / {sqrt(logR$Age) + 1}
logR$Exp <- {sqrt(logR$Exp) -1} / {sqrt(logR$Exp) + 1}
logR$Fem <- {sqrt(logR$Fem) -1} / {sqrt(logR$Fem) + 1}
logR$Self.eff <- {sqrt(logR$Self.eff) -1} / {sqrt(logR$Self.eff) + 1}
logR$Self.eff.act <- {sqrt(logR$Self.eff.act) -1} / {sqrt(logR$Self.eff.act) + 1}
logR$Self.eff.int <- {sqrt(logR$Self.eff.int) -1} / {sqrt(logR$Self.eff.int) + 1}
logR$Social <- {sqrt(logR$Social) -1} / {sqrt(logR$Social) + 1}
logR$Gov.act <- {sqrt(logR$Gov.act) -1} / {sqrt(logR$Gov.act) + 1}




#Recombind all of the data sets and transform to Fisher's Z####
#AD is analyzed data
AD <- rbind(spear, odd, chi, kend, pear, beta, logR)

#Remove the Metric column because they are all persons r now
AD<- select(AD, -Metric)

#now for variance stability in transform to Fisher's Z
AD$RP.both <- .5*{log((1+AD$RP.both)/(1-AD$RP.both))}
AD$RP.act <- .5*{log((1+AD$RP.act)/(1-AD$RP.act))}
AD$RP.int <- .5*{log((1+AD$RP.int)/(1-AD$RP.int))}
AD$R.prob <- .5*{log((1+AD$R.prob)/(1-AD$R.prob))}
AD$R.dam <- .5*{log((1+AD$R.dam)/(1-AD$R.dam))}
AD$Age <- .5*{log((1+AD$Age)/(1-AD$Age))}
AD$Exp <- .5*{log((1+AD$Exp)/(1-AD$Exp))}
AD$Fem <- .5*{log((1+AD$Fem)/(1-AD$Fem))}
AD$Self.eff <- .5*{log((1+AD$Self.eff)/(1-AD$Self.eff))}
AD$Self.eff.act <- .5*{log((1+AD$Self.eff.act)/(1-AD$Self.eff.act))}
AD$Self.eff.int <- .5*{log((1+AD$Self.eff.int)/(1-AD$Self.eff.int))}
AD$Social <- .5*{log((1+AD$Social)/(1-AD$Social))}
AD$Gov.act <- .5*{log((1+AD$Gov.act)/(1-AD$Gov.act))}

#Random Effects: Saved in: WRAD####

#NOTE in this code, this part is not automated I wanted to double check
#The steps of the process, thus if data length changes or variables are added, 
#some of these numbers will have to be adjusted

library(meta)
library(metafor)
library(normtest)
#We use the transformation to fishers Z: so from AD data.....
#WAD stands for Weighted Analyzed Data
AD$se <- sqrt(1/(AD$N - 3))

WAD <- AD

# Experience 
EXP.WAD <- WAD[!is.na(WAD$Exp),] #to check for N (how many studies there are)

sum(as.numeric(EXP.WAD$Group.N), na.rm = TRUE)
summary(EXP.WAD$Country)


Exp.Tau<-metagen(Exp,
                se,
                data=WAD,
                studlab=paste(ID),
                comb.fixed = FALSE,
                comb.random = TRUE,
                method.tau = "PM",
                hakn = TRUE,
                predict=TRUE,
                sm="SMD")
Exp.Tau

#save output
sink(file = "OUTPUT.txt")
RE_model <- Exp.Tau 
RE_model
sink(NULL)


#imput the random effect weights
WAD$w.random<- RE_model[["w.random"]]
sum(WAD$w.random)

#This is the percentatge that each var contributes to the whole
WAD$w.rnd <- WAD$w.random / sum(WAD$w.random)
sum(WAD$w.rnd) #check to make sure it equals 1

#then multiply the ES by by the %
WAD$Weight <- WAD$w.rnd * WAD$Exp

#to check! This should be equal to the output of the earlier model: .Tau
check <- WAD[!is.na(WAD$Weight),]
sum(check$Weight)

#then multiply by number of studies that measured the given factor 
WAD$Weight1 <- WAD$Weight * 27 #This # matchs the number of studies for a given factor

#Then convert it back to Pearsons r from Fisher's z in the column of the orginal ES
WAD$Exp <-{(exp(2*WAD$Weight1)-1)/(exp(2*WAD$Weight1)+1)}


# Age
AGE.WAD <- WAD[!is.na(WAD$Age),] #to check for N (how many studies there are)

sum(as.numeric(AGE.WAD$Group.N), na.rm = TRUE)
summary(AGE.WAD$Country)


Age.Tau<-metagen(Age,
                 se,
                 data=WAD,
                 studlab=paste(ID),
                 comb.fixed = FALSE,
                 comb.random = TRUE,
                 method.tau = "PM",
                 hakn = TRUE,
                 predict=TRUE,
                 sm="SMD")
Age.Tau

#save output
sink(file = "OUTPUT.txt")
RE_model <- Age.Tau 
RE_model
sink(NULL)


#imput the random effect weights
WAD$w.random<- RE_model[["w.random"]]
sum(WAD$w.random)

#This is the percentatge that each var contributes to the whole
WAD$w.rnd <- WAD$w.random / sum(WAD$w.random)
sum(WAD$w.rnd) #check to make sure it equals 1

#then multiply the ES by by the %
WAD$Weight <- WAD$w.rnd * WAD$Age

#to check! This should be equal to the output of the earlier model: .Tau
check <- WAD[!is.na(WAD$Weight),]
sum(check$Weight)

#then multiply by number of studies that measured the given factor 
WAD$Weight2 <- WAD$Weight * 18

#Then convert it back to Pearsons r from Fisher's z in the column of the orginal ES
WAD$Age <-{(exp(2*WAD$Weight2)-1)/(exp(2*WAD$Weight2)+1)}


# Fem
FEM.WAD <- WAD[!is.na(WAD$Fem),] #to check for N (how many studies there are)

sum(as.numeric(FEM.WAD$Group.N), na.rm = TRUE)
summary(FEM.WAD$Country)

Fem.Tau<-metagen(Fem,
                 se,
                 data=WAD,
                 studlab=paste(ID),
                 comb.fixed = FALSE,
                 comb.random = TRUE,
                 method.tau = "PM",
                 hakn = TRUE,
                 predict=TRUE,
                 sm="SMD")
Fem.Tau

#save output
sink(file = "OUTPUT.txt")
RE_model <- Fem.Tau 
RE_model
sink(NULL)


#imput the random effect weights
WAD$w.random<- RE_model[["w.random"]]
sum(WAD$w.random)

#This is the percentatge that each var contributes to the whole
WAD$w.rnd <- WAD$w.random / sum(WAD$w.random)
sum(WAD$w.rnd) #check to make sure it equals 1

#then multiply the ES by by the %
WAD$Weight <- WAD$w.rnd * WAD$Fem

#to check! This should be equal to the output of the earlier model: .Tau
check <- WAD[!is.na(WAD$Weight),]
sum(check$Weight)

#then multiply by number of studies that measured the given factor 
WAD$Weight3 <- WAD$Weight * 17

#Then convert it back to Pearsons r from Fisher's z in the column of the orginal ES
WAD$Fem <-{(exp(2*WAD$Weight3)-1)/(exp(2*WAD$Weight3)+1)}

# RP.both
RP.both.WAD <- WAD[!is.na(WAD$RP.both),] #to check for N (how many studies there are)

sum(as.numeric(RP.both.WAD$Group.N), na.rm = TRUE)
summary(RP.both.WAD$Country)

RP.both.Tau<-metagen(RP.both,
                 se,
                 data=WAD,
                 studlab=paste(ID),
                 comb.fixed = FALSE,
                 comb.random = TRUE,
                 method.tau = "PM",
                 hakn = TRUE,
                 predict=TRUE,
                 sm="SMD")
RP.both.Tau

#save output
sink(file = "OUTPUT.txt")
RE_model <- RP.both.Tau 
RE_model
sink(NULL)


#imput the random effect weights
WAD$w.random<- RE_model[["w.random"]]
sum(WAD$w.random)

#This is the percentatge that each var contributes to the whole
WAD$w.rnd <- WAD$w.random / sum(WAD$w.random)
sum(WAD$w.rnd) #check to make sure it equals 1

#then multiply the ES by by the %
WAD$Weight <- WAD$w.rnd * WAD$RP.both

#to check! This should be equal to the output of the earlier model: .Tau
check <- WAD[!is.na(WAD$Weight),]
sum(check$Weight)

#then multiply by number of studies that measured the given factor 
WAD$Weight4 <- WAD$Weight * 41

#Then convert it back to Pearsons r from Fisher's z in the column of the orginal ES
WAD$RP.both <-{(exp(2*WAD$Weight4)-1)/(exp(2*WAD$Weight4)+1)}


# Self.eff
Self.eff.WAD <- WAD[!is.na(WAD$Self.eff),] #to check for N (how many studies there are)

sum(as.numeric(Self.eff.WAD$Group.N), na.rm = TRUE)
summary(Self.eff.WAD$Country)

Self.eff.Tau<-metagen(Self.eff,
                     se,
                     data=WAD,
                     studlab=paste(ID),
                     comb.fixed = FALSE,
                     comb.random = TRUE,
                     method.tau = "PM",
                     hakn = TRUE,
                     predict=TRUE,
                     sm="SMD")
Self.eff.Tau

#save output
sink(file = "OUTPUT.txt")
RE_model <- Self.eff.Tau
RE_model
sink(NULL)


#imput the random effect weights
WAD$w.random<- RE_model[["w.random"]]
sum(WAD$w.random)

#This is the percentatge that each var contributes to the whole
WAD$w.rnd <- WAD$w.random / sum(WAD$w.random)
sum(WAD$w.rnd) #check to make sure it equals 1

#then multiply the ES by by the %
WAD$Weight <- WAD$w.rnd * WAD$Self.eff

#to check! This should be equal to the output of the earlier model: .Tau
check <- WAD[!is.na(WAD$Weight),]
sum(check$Weight)

#then multiply by number of studies that measured the given factor 
WAD$Weight5 <- WAD$Weight * 21

#Then convert it back to Pearsons r from Fisher's z in the column of the orginal ES
WAD$Self.eff <-{(exp(2*WAD$Weight5)-1)/(exp(2*WAD$Weight5)+1)}


# Social
Social.WAD <- WAD[!is.na(WAD$Social),] #to check for N (how many studies there are)

sum(as.numeric(Social.WAD$Group.N), na.rm = TRUE)
summary(Social.WAD$Country)

Social.Tau<-metagen(Social,
                      se,
                      data=WAD,
                      studlab=paste(ID),
                      comb.fixed = FALSE,
                      comb.random = TRUE,
                      method.tau = "PM",
                      hakn = TRUE,
                      predict=TRUE,
                      sm="SMD")
Social.Tau

#save output
sink(file = "OUTPUT.txt")
RE_model <- Social.Tau
RE_model
sink(NULL)


#imput the random effect weights
WAD$w.random<- RE_model[["w.random"]]
sum(WAD$w.random)

#This is the percentatge that each var contributes to the whole
WAD$w.rnd <- WAD$w.random / sum(WAD$w.random)
sum(WAD$w.rnd) #check to make sure it equals 1

#then multiply the ES by by the %
WAD$Weight <- WAD$w.rnd * WAD$Social

#to check! This should be equal to the output of the earlier model: .Tau
check <- WAD[!is.na(WAD$Weight),]
sum(check$Weight)

#then multiply by number of studies that measured the given factor 
WAD$Weight6 <- WAD$Weight * 13

#Then convert it back to Pearsons r from Fisher's z in the column of the orginal ES
WAD$Social <-{(exp(2*WAD$Weight6)-1)/(exp(2*WAD$Weight6)+1)}


# Gov.act
Gov.act.WAD <- WAD[!is.na(WAD$Gov.act),] #to check for N (how many studies there are)

sum(as.numeric(Gov.act.WAD$Group.N), na.rm = TRUE)
summary(Gov.act.WAD$Country)

Gov.act.Tau<-metagen(Gov.act,
                    se,
                    data=WAD,
                    studlab=paste(ID),
                    comb.fixed = FALSE,
                    comb.random = TRUE,
                    method.tau = "PM",
                    hakn = TRUE,
                    predict=TRUE,
                    sm="SMD")
Gov.act.Tau

#save output
sink(file = "OUTPUT.txt")
RE_model <- Gov.act.Tau
RE_model
sink(NULL)


#imput the random effect weights
WAD$w.random<- RE_model[["w.random"]]
sum(WAD$w.random)

#This is the percentatge that each var contributes to the whole
WAD$w.rnd <- WAD$w.random / sum(WAD$w.random)
sum(WAD$w.rnd) #check to make sure it equals 1

#then multiply the ES by by the %
WAD$Weight <- WAD$w.rnd * WAD$Gov.act

#to check! This should be equal to the output of the earlier model: .Tau
check <- WAD[!is.na(WAD$Weight),]
sum(check$Weight)

#then multiply by number of studies that measured the given factor 
WAD$Weight7 <- WAD$Weight * 20

#Then convert it back to Pearsons r from Fisher's z in the column of the orginal ES
WAD$Gov.act <-{(exp(2*WAD$Weight7)-1)/(exp(2*WAD$Weight7)+1)}


#
# R.prob
R.prob.WAD <- WAD[!is.na(WAD$R.prob),] #to check for N (how many studies there are)

sum(as.numeric(R.prob.WAD$Group.N), na.rm = TRUE)
summary(R.prob.WAD$Country)

R.prob.Tau<-metagen(R.prob,
                     se,
                     data=WAD,
                     studlab=paste(ID),
                     comb.fixed = FALSE,
                     comb.random = TRUE,
                     method.tau = "PM",
                     hakn = TRUE,
                     predict=TRUE,
                     sm="SMD")
R.prob.Tau

#save output
sink(file = "OUTPUT.txt")
RE_model <- R.prob.Tau
RE_model
sink(NULL)


#imput the random effect weights
WAD$w.random<- RE_model[["w.random"]]
sum(WAD$w.random)

#This is the percentatge that each var contributes to the whole
WAD$w.rnd <- WAD$w.random / sum(WAD$w.random)
sum(WAD$w.rnd) #check to make sure it equals 1

#then multiply the ES by by the %
WAD$Weight <- WAD$w.rnd * WAD$R.prob

#to check! This should be equal to the output of the earlier model: .Tau
check <- WAD[!is.na(WAD$Weight),]
sum(check$Weight)

#then multiply by number of studies that measured the given factor 
WAD$Weight8 <- WAD$Weight * 15

#Then convert it back to Pearsons r from Fisher's z in the column of the orginal ES
WAD$R.prob <-{(exp(2*WAD$Weight8)-1)/(exp(2*WAD$Weight8)+1)}


#
# R.dam
R.dam.WAD <- WAD[!is.na(WAD$R.dam),] #to check for N (how many studies there are)

sum(as.numeric(R.dam.WAD$Group.N), na.rm = TRUE)
summary(R.dam.WAD$Country)

R.dam.Tau<-metagen(R.dam,
                     se,
                     data=WAD,
                     studlab=paste(ID),
                     comb.fixed = FALSE,
                     comb.random = TRUE,
                     method.tau = "PM",
                     hakn = TRUE,
                     predict=TRUE,
                     sm="SMD")
R.dam.Tau

#save output
sink(file = "OUTPUT.txt")
RE_model <- R.dam.Tau
RE_model
sink(NULL)


#imput the random effect weights
WAD$w.random<- RE_model[["w.random"]]
sum(WAD$w.random)

#This is the percentatge that each var contributes to the whole
WAD$w.rnd <- WAD$w.random / sum(WAD$w.random)
sum(WAD$w.rnd) #check to make sure it equals 1

#then multiply the ES by by the %
WAD$Weight <- WAD$w.rnd * WAD$R.dam

#to check! This should be equal to the output of the earlier model: .Tau
check <- WAD[!is.na(WAD$Weight),]
sum(check$Weight)

#then multiply by number of studies that measured the given factor 
WAD$Weight9 <- WAD$Weight * 15

#Then convert it back to Pearsons r from Fisher's z in the column of the orginal ES
WAD$R.dam <-{(exp(2*WAD$Weight9)-1)/(exp(2*WAD$Weight9)+1)}



# Self.eff.int
Self.eff.int.WAD <- WAD[!is.na(WAD$Self.eff.int),] #to check for N (how many studies there are)

sum(as.numeric(Self.eff.int.WAD$Group.N), na.rm = TRUE)
summary(Self.eff.int.WAD$Country)

Self.eff.int.Tau<-metagen(Self.eff.int,
                   se,
                   data=WAD,
                   studlab=paste(ID),
                   comb.fixed = FALSE,
                   comb.random = TRUE,
                   method.tau = "PM",
                   hakn = TRUE,
                   predict=TRUE,
                   sm="SMD")
Self.eff.int.Tau

#save output
sink(file = "OUTPUT.txt")
RE_model <- Self.eff.int.Tau
RE_model
sink(NULL)


#imput the random effect weights
WAD$w.random<- RE_model[["w.random"]]
sum(WAD$w.random)

#This is the percentatge that each var contributes to the whole
WAD$w.rnd <- WAD$w.random / sum(WAD$w.random)
sum(WAD$w.rnd) #check to make sure it equals 1

#then multiply the ES by by the %
WAD$Weight <- WAD$w.rnd * WAD$Self.eff.int

#to check! This should be equal to the output of the earlier model: .Tau
check <- WAD[!is.na(WAD$Weight),]
sum(check$Weight)

#then multiply by number of studies that measured the given factor 
WAD$Weight10 <- WAD$Weight * 10

#Then convert it back to Pearsons r from Fisher's z in the column of the orginal ES
WAD$Self.eff.int <-{(exp(2*WAD$Weight10)-1)/(exp(2*WAD$Weight10)+1)}

#
# Self.eff.act
Self.eff.act.WAD <- WAD[!is.na(WAD$Self.eff.act),] #to check for N (how many studies there are)

sum(as.numeric(Self.eff.act.WAD$Group.N), na.rm = TRUE)
summary(Self.eff.act.WAD$Country)


Self.eff.act.Tau<-metagen(Self.eff.act,
                          se,
                          data=WAD,
                          studlab=paste(ID),
                          comb.fixed = FALSE,
                          comb.random = TRUE,
                          method.tau = "PM",
                          hakn = TRUE,
                          predict=TRUE,
                          sm="SMD")
Self.eff.act.Tau

#save output
sink(file = "OUTPUT.txt")
RE_model <- Self.eff.act.Tau
RE_model
sink(NULL)


#imput the random effect weights
WAD$w.random<- RE_model[["w.random"]]
sum(WAD$w.random)

#This is the percentatge that each var contributes to the whole
WAD$w.rnd <- WAD$w.random / sum(WAD$w.random)
sum(WAD$w.rnd) #check to make sure it equals 1

#then multiply the ES by by the %
WAD$Weight <- WAD$w.rnd * WAD$Self.eff.act

#to check! This should be equal to the output of the earlier model: .Tau
check <- WAD[!is.na(WAD$Weight),]
sum(check$Weight)

#then multiply by number of studies that measured the given factor 
WAD$Weight11 <- WAD$Weight * 14

#Then convert it back to Pearsons r from Fisher's z in the column of the orginal ES
WAD$Self.eff.act <-{(exp(2*WAD$Weight11)-1)/(exp(2*WAD$Weight11)+1)}



#RP.act
RP.act.WAD <- WAD[!is.na(WAD$RP.act),] #to check for N (how many studies there are)

sum(as.numeric(RP.act.WAD$Group.N), na.rm = TRUE)
summary(RP.act.WAD$Country)

RP.act.Tau<-metagen(RP.act,
                          se,
                          data=WAD,
                          studlab=paste(ID),
                          comb.fixed = FALSE,
                          comb.random = TRUE,
                          method.tau = "PM",
                          hakn = TRUE,
                          predict=TRUE,
                          sm="SMD")
RP.act.Tau

#save output
sink(file = "OUTPUT.txt")
RE_model <- RP.act.Tau
RE_model
sink(NULL)


#imput the random effect weights
WAD$w.random<- RE_model[["w.random"]]
sum(WAD$w.random)

#This is the percentatge that each var contributes to the whole
WAD$w.rnd <- WAD$w.random / sum(WAD$w.random)
sum(WAD$w.rnd) #check to make sure it equals 1

#then multiply the ES by by the %
WAD$Weight <- WAD$w.rnd * WAD$RP.act

#to check! This should be equal to the output of the earlier model: .Tau
check <- WAD[!is.na(WAD$Weight),]
sum(check$Weight)

#then multiply by number of studies that measured the given factor 
WAD$Weight12 <- WAD$Weight * 30

#Then convert it back to Pearsons r from Fisher's z in the column of the orginal ES
WAD$RP.act <-{(exp(2*WAD$Weight12)-1)/(exp(2*WAD$Weight12)+1)}


#RP.int
RP.int.WAD <- WAD[!is.na(WAD$RP.int),] #to check for N (how many studies there are)

sum(as.numeric(RP.int.WAD$Group.N), na.rm = TRUE)
summary(RP.int.WAD$Country)

RP.int.Tau<-metagen(RP.int,
                    se,
                    data=WAD,
                    studlab=paste(ID),
                    comb.fixed = FALSE,
                    comb.random = TRUE,
                    method.tau = "PM",
                    hakn = TRUE,
                    predict=TRUE,
                    sm="SMD")
RP.int.Tau

#save output
sink(file = "OUTPUT.txt")
RE_model <- RP.int.Tau
RE_model
sink(NULL)


#imput the random effect weights
WAD$w.random<- RE_model[["w.random"]]
sum(WAD$w.random)

#This is the percentatge that each var contributes to the whole
WAD$w.rnd <- WAD$w.random / sum(WAD$w.random)
sum(WAD$w.rnd) #check to make sure it equals 1

#then multiply the ES by by the %
WAD$Weight <- WAD$w.rnd * WAD$RP.int

#to check! This should be equal to the output of the earlier model: .Tau
check <- WAD[!is.na(WAD$Weight),]
sum(check$Weight)

#then multiply by number of studies that measured the given factor 
WAD$Weight13 <- WAD$Weight * 14

#Then convert it back to Pearsons r from Fisher's z in the column of the orginal ES
WAD$RP.int <-{(exp(2*WAD$Weight13)-1)/(exp(2*WAD$Weight13)+1)}


#WRAD stand for Weighted R (as in Rearsons r) Analyzed Data
WRAD <- select(WAD, -c(w.random, w.rnd)) #remove these as they are meaningless because they just apply to the last converted factor

#S.S.Results####
RP.BOTH <- WRAD[!is.na(WRAD$RP.both),]
RP.ACT <- WRAD[!is.na(WRAD$RP.act),]
RP.INT <- WRAD[!is.na(WRAD$RP.int),]
R.PROB <- WRAD[!is.na(WRAD$R.prob),]
SELF.EFF.INT <- WRAD[!is.na(WRAD$Self.eff.int),]
EXP <- WRAD[!is.na(WRAD$Exp),]
EXP <- WRAD[!is.na(WRAD$Exp),]

#Ind
summary(lm(WRAD$Exp ~ WRAD$Ind +WRAD$Uncert))


EXP <- WRAD[!is.na(WRAD$Exp),]
sum(na.omit(EXP$Group.N))

ggplot(WRAD, aes(Ind, Exp))+
  geom_point(aes(size=N, color = GDP))+
  geom_smooth(method = "lm", se=TRUE) +
  labs(x = "Individualism", y = "E.S. (r) of Flood Experience motivating Adaptation",
       title = "Flood Experience's influence on \nAdaptation & Individualism") + 
  theme(plot.title = element_text(hjust = 0.5))+
  scale_color_gradient(low = "black", high = "green")
summary(lm(WRAD$Exp ~ WRAD$Ind))
summary(lm(WRAD$Exp ~ WRAD$GDP))
summary(lm(WRAD$Exp ~ WRAD$Pwr.dist))
#
SELF.EFF.ACT <- WRAD[!is.na(WRAD$Self.eff.act),]
sum(na.omit(SELF.EFF.ACT$Group.N))

ggplot(WRAD, aes(Ind, Self.eff.act))+
  geom_point(aes(size= N, color = GDP))+
  geom_smooth(method = "lm", se=TRUE) +
  labs(x = "Individualism", y = "E.S. (r) of Self Efficacy motivating Undergone Adaptation", 
       title = "Self Efficacy's influence on Realized Adaptation & Individualism")
summary(lm(WRAD$Self.eff.act ~ WRAD$Ind))

#Pwr Dist
ggplot(WRAD, aes(Pwr.dist, Exp))+
  geom_point(aes(size= N, color = GDP)) +
  geom_smooth(method = "lm", se=TRUE) +
  labs(x = "Power Distance", y = "E.S. (r) of Flood Experience motivating Adaptation",
       title = "Flood Experience's influence on Adaptation & Power Distance")
summary(lm(WRAD$Exp ~ WRAD$Pwr.dist))
#
SELF.EFF <- WRAD[!is.na(WRAD$Self.eff),]
sum(na.omit(SELF.EFF$Group.N))

ggplot(RAD, aes(Pwr.dist, Self.eff))+
  geom_point(aes(size= N, color = GDP))+ 
  geom_smooth(method = "lm", se=TRUE) +
  labs(x = "Power Distance", y = "E.S. (r) of Flood Experience motivating Adaptation", 
       title = "Self Efficacy's influence on Adaptation & Power Distance")
summary(lm(WRAD$Self.eff ~ WRAD$Pwr.dist))
#
GOV.ACT <- WRAD[!is.na(WRAD$Gov.act),]
sum(na.omit(GOV.ACT$Group.N))

ggplot(WRAD, aes(Pwr.dist, Gov.act))+
  geom_point(aes(size= N, color = GDP))+ 
  geom_smooth(method = "lm", se=TRUE) +
  labs(x = "Power Distance", y = "E.S. (r) of Institutional Faith motivating Adaptation", 
       title = "Institutional Faith's influence on \nAdaptation & Power Distance") +
  theme(plot.title = element_text(hjust = 0.5))+
  scale_color_gradient(low = "black", high = "green")
summary(lm(WRAD$Gov.act ~ WRAD$Pwr.dist))


#Outlier test 
#Malaysia is the country for which Power Dist = 100
#So remove it for comparison

Outlier <- WRAD[WRAD$Country != 'Malaysia',]

ggplot(Outlier, aes(Pwr.dist, Gov.act))+
  geom_point(aes(size= N, color = GDP))+ 
  geom_smooth(method = "lm", se=TRUE) 
summary(lm(Outlier$Gov.act ~ Outlier$Pwr.dist))










#Masc
R.PROB <- WRAD[!is.na(WRAD$R.prob),]
sum(na.omit(R.PROB$Group.N))


ggplot(WRAD, aes(Masc, R.prob))+
  geom_point(aes(size= N, shape = factor(Global)))+ 
  geom_smooth(method = "lm", se=TRUE) +
  labs(x = "Masculinity", y = "E.S. (r) of Precived Flood Probability motivating Adaptation", 
       title = "Flood Probability's influence on Adaptation & Masculinity")
summary(lm(WRAD$R.prob ~ WRAD$Masc))

#Long Term Orient
R.DAM <- WRAD[!is.na(WRAD$R.dam),]
sum(na.omit(R.DAM$Group.N))

ggplot(WRAD, aes(Long.orient, R.dam))+
  geom_point(aes(size= N, color = factor(Global)))+ 
  geom_smooth(method = "lm", se=TRUE) +
  labs(x = "Long Term Orientation", y = "E.S. (r) of Precived Flood Damage motivating Adaptation", 
       title = "Flood Damage's influence on Adaptation & Long Term Orientation")
summary(lm(WRAD$R.dam ~ WRAD$Long.orient))

#Indulgence
ggplot(WRAD, aes(Indulge, R.prob))+
  geom_point(aes(size= N, color = GDP))+ 
  geom_smooth(method = "lm", se=TRUE) +
  scale_color_gradient(low = "black", high = "green") +
  labs(x = "Indulgence", y = "E.S. (r) of Precived Flood Probability motivating Adaptation", 
       title = "Flood Probability's influence on Adaptation & Indulgence")
summary(lm(WRAD$R.prob~ WRAD$Indulge))




#Culture GRAPHING FOR Paper####


cor.test(WRAD$Ind, WRAD$GDP, method = c("pearson"))


#cant do ind and pwr dist because 
summary(lm(WRAD$Ind ~ WRAD$Pwr.dist))

#Multiple regression
summary(lm(WRAD$Exp ~ WRAD$Ind + WRAD$Uncert))

plot(lm(WRAD$Exp ~ WRAD$Ind + WRAD$Uncert))

summary(lm(WRAD$Ind ~ WRAD$Uncert))
plot(WRAD$Exp ~ WRAD$Uncert)

E.Ind<- ggplot(WRAD, aes(Ind, Exp))+
  geom_point(aes(size=N, color = GDP))+
  geom_smooth(method = "lm", se=TRUE) +
 labs(x = "Individualism", y = "") + 
  theme(plot.title = element_text(hjust = 0.5))+
  scale_color_gradient(low = "black", high = "green")+
  theme(legend.position = "none") +
  xlim(0, 100)
summary(lm(WRAD$Exp ~ WRAD$Ind))
#
E.Pwr<- ggplot(WRAD, aes(Pwr.dist, Exp))+
  geom_point(aes(size=N, color = GDP))+
  geom_smooth(method = "lm", se=TRUE) +
  labs(x = "Power Distance", y = "") + 
 # theme(plot.title = element_text(hjust = 0.5))+
  scale_color_gradient(low = "black", high = "green")+
  theme(legend.position = "none")
summary(lm(WRAD$Exp ~ WRAD$Pwr.dist))
#
E.Uncert<- ggplot(WRAD, aes(Uncert, Exp))+
  geom_point(aes(size=N, color = GDP))+
  geom_smooth(method = "lm", se=TRUE) +
 labs(x = "Uncertainty Avoidance", y = "") + 
  #theme(plot.title = element_text(hjust = 0.5))+
  scale_color_gradient(low = "black", high = "green") +
  theme(legend.position = "none")
summary(lm(WRAD$Exp ~ WRAD$Uncert))



p_load(ggpubr)
theme_set(theme_pubr())

Exp31 <- ggarrange(E.Ind, E.Pwr, E.Uncert,
          labels = c(" ", " ", " "),
          common.legend = TRUE, legend = "bottom",
          ncol = 1, nrow = 3)



#for one on top
#Exp3 <- ggarrange(
 # E.Ind,                # First row with line plot
  # Second row with box and dot plots
#  ggarrange(E.Pwr, E.Uncert, ncol = 2, labels = c("", "")), 
#  nrow = 2, 
#  labels = "",# Label of the line plot
#  common.legend = TRUE, legend = "bottom"
#) 

Exp <- annotate_figure(Exp31,
                top = text_grob("Flood Experience and \nThree Cultural Dimensions", 
                                color = "black", 
                                face = "bold", 
                                size = 20),
                left = text_grob("ES of Flood Experience in \nMotivating Adaptation", 
                                color = "black", 
                                #face = "bold", 
                                size = 12,
                                rot = 90))

# Pwr dist and Indulgence in proper form  

IFPD <- ggplot(WRAD, aes(Pwr.dist, Gov.act))+
  geom_point(aes(size= N, color = GDP))+ 
  geom_smooth(method = "lm", se=TRUE) +
  labs(x = "Power Distance", y = "ES of Institutional Faith \nMotivating Adaptation", 
       title = "Institutional Faith's Influence \non Adaptation & Power Distance") +
  theme(plot.title = element_text(hjust = 0.5, size = 16, face = 'bold'),
        axis.line = element_line(colour = "black"), legend.position = "bottom")+
  scale_color_gradient(low = "black", high = "green") +
  theme(panel.background = element_rect(fill = "white"))
summary(lm(WRAD$Gov.act ~ WRAD$Pwr.dist))



IRP <- ggplot(WRAD, aes(Indulge, R.prob))+
  geom_point(aes(size= N, color = GDP))+ 
  geom_smooth(method = "lm", se=TRUE) +
  scale_color_gradient(low = "black", high = "green") +
  labs(x = "Indulgence", y = "ES of Precived Flood Probability \nMotivating Adaptation", 
       title = "Flood Probability's Influence \non Adaptation & Indulgence") +
  theme(plot.title = element_text(hjust = 0.5, size = 16, face = 'bold'),
        axis.line = element_line(colour = "black"), legend.position = "bottom")+
  scale_x_continuous(limits = c(35,70))+
  theme(panel.background = element_rect(fill = "white"))
summary(lm(WRAD$R.prob~ WRAD$Indulge))


ggarrange(
  IFPD,                # First row with line plot
  # Second row with plots
  ggarrange(IRP, ncol = 2, labels = c("", "")), 
  nrow = 1, 
  labels = "",# Label of the line plot
  common.legend = TRUE, legend = "bottom")






#Creditable Intervals for Effect sizes####

p_load(statsr)

#To first see individually
#Risk Perception (Both)
bayes_inference(y=RP.both, x=NULL, data=WRAD, type = 'ht', statistic = 'mean', alternative = 'twosided', null =0, prior='JZS',
                r=1, method = 'theo', show_summ = FALSE)
#Self Efficacy 
bayes_inference(y=Self.eff, x=NULL, data=WRAD,type = 'ht', statistic = 'mean', alternative = 'twosided', null =0, prior='JZS',
                r=1, method = 'theo', show_summ = FALSE)
#Experience 
bayes_inference(y=Exp, x=NULL, data=WRAD,type = 'ht', statistic = 'mean', alternative = 'twosided', null =0, prior='JZS',
                r=1, method = 'theo', show_summ = FALSE)
#Gender
bayes_inference(y=Fem, x=NULL, data=WRAD,type = 'ht', statistic = 'mean', alternative = 'twosided', null =0, prior='JZS',
                r=1, method = 'theo', show_summ = FALSE)
#Age
bayes_inference(y=Age, x=NULL, data=WRAD,type = 'ht', statistic = 'mean', alternative = 'twosided', null =0, prior='JZS',
                r=1, method = 'theo', show_summ = FALSE)
#Social
bayes_inference(y=Social, x=NULL, data=WRAD,type = 'ht', statistic = 'mean', alternative = 'twosided', null =0, prior='JZS',
                r=1, method = 'theo', show_summ = FALSE)
#Intutional Influence
bayes_inference(y=Gov.act, x=NULL, data=WRAD,type = 'ht', statistic = 'mean', alternative = 'twosided', null =0, prior='JZS',
                r=1, method = 'theo', show_summ = TRUE)

p_load(tidyverse, dplyr, dummies, janitor, sjmisc, haven, ggthemes, ggmcmc, texreg, gridExtra, tidybayes, sjPlot, broom)


# graph
ridges_dat_flat <- WRAD %>% 
  select(RP.both, Self.eff, Exp, Age, Fem, Social, Gov.act) %>% 
  gather(key, value) %>% 
  mutate(key = case_when(
    key == "RP.both" ~ "Risk Perception \n(N=41)",
    key == "Self.eff" ~ "Self Efficacy \n(N=21)",
    key == "Exp" ~ "Flood Experience \n(N=27)",
    key == "Age" ~ "Age \n(N=18)",
    key == "Fem" ~ "Female Gender \n(N=17)",
    key == "Social" ~ "Social Influence \n(N=13)",
    key == "Gov.act" ~ "Institutional Faith \n(N=20)"
  )) %>% 
  mutate(key = fct_relevel(key, c("Risk Perception \n(N=41)",
                                  "Self Efficacy \n(N=21)",
                                  "Flood Experience \n(N=27)",
                                  "Age \n(N=18)",
                                  "Female Gender \n(N=17)",
                                  "Social Influence \n(N=13)",
                                  "Institutional Faith \n(N=20)"
  )))

ridges_dat_flat<- na.omit(ridges_dat_flat)


mean_dat_flat <- ridges_dat_flat %>% 
  group_by(key) %>% 
  summarize_all(mean)


  



Interval <- ridges_dat_flat %>%
  ggplot(aes(x = value, y = key)) +
  geom_halfeyeh() +
  geom_vline(xintercept = 0, linetype = "dotted") +
  stat_intervalh(aes(x = value),
                 .width = c(.8, .9, .95)
                 ) +
  # geom_point(aes(x = mean(value), group = key)) +
  scale_color_grey("High Density Intervals", start = 0.5, end = 0.1) +
  theme_hc() +
  geom_text(data = mean_dat_flat,
            aes(x = value, label = round(value, 2), group = key), 
            nudge_y = 0.2) +
  geom_point(data = mean_dat_flat, aes(x = value, group = key), color = "white") +
  labs(title = "Credible Intervals & Effect Sizes for \nFactors Influencing Flooding Adaptation", 
       x = "Effect Size (Pearson's r) Weighted by Random Effects",
       y = "") +
  theme(legend.position = "bottom", 
        plot.title = element_text(size = 18, hjust = 0.4, face = 'bold'),
        axis.text = element_text(size = 15),
        axis.title = element_text(size = 15))





#ES for Social Vs. Instutional####
###
library(BayesFactor)
library(statsr)
#Components of risk: Probability and Damages 
ggplot(AD, aes(R.prob)) +
  geom_density()

ggplot(AD, aes(R.dam)) +
  geom_density()
#InfAD stands for Influencial Analyzed Data
InfAD <- AD

InfAD <- InfAD %>% 
  select(Social, Gov.act) %>% 
  gather(key, value) %>% 
  mutate(key = case_when(
    key == "Social" ~ "Social Influence",
    key == "Gov.act" ~ "Instutional Trust"
  )) %>% 
  mutate(key = fct_relevel(key, c("Social Influence",
                                  "Instutional Trust"
  )))

#Remove the NAs
InfAD <- InfAD[!is.na(InfAD$value),]
#BAYES FACTOR
bayes_inference(y=value, x=key, data=InfAD,type = 'ht', statistic = 'mean', alternative = 'twosided', null =0, prior='JZS',
                r=1, method = 'theo', show_summ = FALSE)

#This (above) plots the likely difference between the means, but what does it look like together? (see below)

p_load(plyr)
# Find the mean of each group
cdat1 <- ddply(InfAD, "key", summarise, value.mean=mean(value))
cdat1


# Overlaid histograms with means
ggplot(InfAD, aes(x=value, fill=key)) +
  geom_histogram(binwidth=.05, alpha=.5, position="identity") +
  geom_vline(data=cdat1, aes(xintercept=value.mean,  colour=key),
             linetype="dashed", size=1)

# Density plots with means
ggplot(InfAD, aes(x=value, colour=key)) +
  geom_density() +
  geom_vline(data=cdat1, aes(xintercept=value.mean,  colour=key),
             linetype="dashed", size=1) +
  labs(x="Effect Size", y="Density",
       title="P.D.F. for the Effect Sizes of Influence")




#RP for Intention vs. Action####
p_load(BayesFactor, statsr)

#Action and intent and Risk Perception 
ggplot(WRAD, aes(RP.act)) +
  geom_density()

ggplot(WRAD, aes(RP.int)) +
  geom_density()

t.test(WRAD$RP.int, WRAD$RP.act)


#First Remove the Finland study because this study grouped both ACTION and INTENTION together
WRAD1<- WRAD[WRAD$Country != "Finland",]

wilcox.test(WRAD1$RP.act, WRAD1$RP.int)

wilcox.test(WRAD1$Self.eff.act, WRAD1$Self.eff.int)


#BFAD is (B)aye's (F)actor (A)nalyzed (D)ata
BFAD <- WRAD1 %>% 
  select(RP.int, RP.act) %>% 
  gather(key, value) %>% 
  mutate(key = case_when(
    key == "RP.int" ~ "R.P. for Intent",
    key == "RP.act" ~ "R.P. for Action"
  )) %>% 
  mutate(key = fct_relevel(key, c("R.P. for Intent",
                                  "R.P. for Action"
  )))

#Remove the NAs
BFAD <- BFAD[!is.na(BFAD$value),]
#BAYES FACTOR
bayes_inference(y=value, x=key, data=BFAD,type = 'ht', statistic = 'mean', alternative = 'twosided', null =0, prior='JZS',
                r=1, method = 'theo', show_summ = TRUE)

#This (above) plots the likely difference between the means, but what does it look like together? (see below)

p_load(plyr)
# Find the mean of each group
cdat <- ddply(BFAD, "key", summarise, value.mean=mean(value))
cdat


# Overlaid histograms with means
ggplot(BFAD, aes(x=value, fill=key)) +
  geom_histogram(binwidth=.05, alpha=.5, position="identity") +
  geom_vline(data=cdat, aes(xintercept=value.mean,  colour=key),
             linetype="dashed", size=1)

# Density plots with means
ggplot(BFAD, aes(x=value, fill = factor(key))) +
  geom_density(alpha = .4) +
  scale_fill_manual(values = c("#00FF66", "#000000")) +
  geom_vline(data=cdat, aes(xintercept=value.mean,  colour=key),
             linetype="dashed", size=1, show.legend = FALSE) +
  scale_color_manual(values = c('darkgreen','black'))+
  guides(fill=guide_legend(" "), colour= FALSE) +
  theme(legend.justification=c(1,1), legend.position=c(1,.85), 
        axis.text.y=element_blank(),axis.ticks.y =element_blank())+
  labs(x="Effect Size (Pearson's r)", y="",
       title="Probability Density Function \nfor the Effect Sizes of Risk Perception", fill = "Intention vs. Action") +
  theme(panel.grid.minor.x = element_line(color = "grey"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size = 16, hjust = 0.5, face = 'bold')
  )


  


#Difference Between RP for Damage and Probability####

library(BayesFactor)
library(statsr)
###
#Action and intent and Risk Perception 
ggplot(AD, aes(R.dam)) +
  geom_density()

ggplot(AD, aes(R.prob)) +
  geom_density()

t.test(AD$R.dam, AD$R.prob)

#DPR is Damage, Probability, Risk
DPR<- RAD

DPR <- DPR %>% 
  select(R.prob, R.dam) %>% 
  gather(key, value) %>% 
  mutate(key = case_when(
    key == "R.prob" ~ "Probaility",
    key == "R.dam" ~ "Severity"
  )) %>% 
  mutate(key = fct_relevel(key, c("Probaility",
                                  "Severity"
  )))

#Remove the NAs
DPR <- DPR[!is.na(DPR$value),]
#BAYES FACTOR
bayes_inference(y=value, x=key, data=DPR,type = 'ht', statistic = 'mean', alternative = 'twosided', null =0, prior='JZS',
                r=1, method = 'theo', show_summ = FALSE)







